' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion. 
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports Microsoft.VisualBasic
Imports System.Data
Imports System.Data.Common

Public Class UserManagerDB

  ''' <summary>
  ''' Ukryj konstruktor, aby unikn tworzenia egzemplarzy klasy UserManagerDB.
  ''' </summary>
  Private Sub New()
  End Sub

  ''' <summary>
  ''' Pobiera list rl przypisanych uytkownikowi.
  ''' </summary>
  ''' <param name="userName">Nazwa uytkownika.</param>
  ''' <param name="passwordHash">Skrt hasa uytkownika.</param>
  ''' <returns>ArrayList z rolami (zapisanymi jako acuchy tekstowe) lub Nothing jeli uytkownik nie mg by uwierzytelniony.</returns>
  Public Shared Function GetUserRoles( _
      ByVal userName As String, ByVal passwordHash As String _
      ) As ArrayList

    Dim myFactory As DbProviderFactory = _
      DbProviderFactories.GetFactory( _
      AppConfiguration.ConnectionStringSettings.ProviderName)

    Dim myConnection As DbConnection = myFactory.CreateConnection()

    myConnection.ConnectionString = _
        AppConfiguration.ConnectionStringSettings.ConnectionString
    myConnection.Open()

    Dim myCommand As DbCommand = myConnection.CreateCommand()

    myCommand.CommandText = "sprocUserGetRoles"
    myCommand.CommandType = CommandType.StoredProcedure

    Dim param As DbParameter
    param = myCommand.CreateParameter()
    param.ParameterName = DalHelpers.ReturnCommandParamName("userName")
    param.DbType = DbType.String
    param.Value = userName
    myCommand.Parameters.Add(param)

    param = myCommand.CreateParameter()
    param.ParameterName = DalHelpers.ReturnCommandParamName("passwordHash")
    param.DbType = DbType.String
    param.Value = passwordHash
    myCommand.Parameters.Add(param)

    Dim arrRoles As ArrayList = Nothing

    Dim myDataReader As DbDataReader = myCommand.ExecuteReader( _
        CommandBehavior.CloseConnection)
    If myDataReader.HasRows Then
      arrRoles = New ArrayList()
      Do While myDataReader.Read()
        arrRoles.Add(myDataReader.GetString( _
            myDataReader.GetOrdinal("Description")))
      Loop
    End If

    Return arrRoles

  End Function

End Class
